var videoWrappers = document.querySelectorAll('.video-wrapper');

function renderVideoPlayButtons() {
    videoWrappers.forEach(function(videoWrapper) {
        var video = videoWrapper.querySelector("video");
        if (video) {
            formatVideoPlayButton(videoWrapper);
            video.classList.add('has-media-controls-hidden');
            
            var videoPlayButton = videoWrapper.querySelector('.video-overlay-play-button');
            videoPlayButton.addEventListener('click', function() {
                hideVideoPlayButton(video, videoPlayButton);
            });
        }
    });
}

function formatVideoPlayButton(videoWrapper) {
    videoWrapper.insertAdjacentHTML('beforeend', '<svg class="video-overlay-play-button" viewBox="0 0 200 200" alt="Play video"><circle cx="100" cy="100" r="90" fill="none" stroke-width="15" stroke="#fff"/><polygon points="70, 55 70, 145 145, 100" fill="#fff"/></svg>');
}

function hideVideoPlayButton(video, videoPlayButton) {
    video.play()
    videoPlayButton.classList.add('is-hidden')
    video.classList.remove('has-media-controls-hidden')
    video.setAttribute('controls', 'controls')
}

renderVideoPlayButtons();